/*************************************************************************
    > File Name: 01queue.c
    > Author: yuri
    > Mail: yuri_chen_28@163.com
    > Created Time: 2019年05月04日 星期六 10时14分34秒
	> 顺序存储方式-链式结构实现队列
 ************************************************************************/

#include<stdlib.h>
#include"01queue.h"
typedef struct node
{
	int num;
	struct node *p_next;
}node;

static node head;

//初始化函数
void init()
{
	head.p_next = NULL;
}

//清理函数
void deinit()
{
	while(head.p_next)
	{
		node *p_temp = head.p_next;
		head.p_next = p_temp -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
}

//判断是否满的函数
int full()
{
	return 0;
}

//判断是否空的函数
int empty()
{
	return !(head.p_next);
}

//放数据的函数
void push(int num)
{
	node *p_temp = (node *)malloc(sizeof(node));
	node *p_node = NULL;
	if(p_temp)
	{
		p_temp -> num = num;
		p_temp -> p_next = NULL;
		for(p_node = &head;p_node;p_node = p_node -> p_next)
		{
			if(!(p_node -> p_next))
			{
				p_node -> p_next = p_temp;
				break;
			}
		}

	}

}

//取数据的函数
int pop()
{
	int ret = 1 << 31;
	if(head.p_next)
	{
		node *p_temp = head.p_next;
		ret = head.p_next -> num;
		head.p_next = p_temp -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
	return ret;
}

//取下一个数字的函数
int front()
{
	int ret = 1 << 31;
	if(head.p_next)
	{
		ret = head.p_next -> num;
	}
	return ret;
}

//获得有效数据个数的函数
int size()
{
	int cnt = 0;
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		if(p_node -> p_next)
		{
			cnt++;
		}
	}
	return cnt;
}
