/*************************************************************************
    > File Name: 01stack.c
    > Author: yuri
    > Mail: yuri_chen_28@163.com
    > Created Time: 2019年05月01日 星期三 16时39分31秒
	> 顺序物理结构-链式结构实现栈
 ************************************************************************/

#include<stdlib.h>
#include"01stack.h"
typedef struct node
{
	int num;
	struct node *p_next;
}node;

static node head;

//初始化函数
void init()
{
	head.p_next = NULL;
}

//清除函数
void deinit()
{
	node *p_temp = NULL;
	while(head.p_next)
	{
		//删除所有一节点
		p_temp = head.p_next;
		head.p_next = head.p_next -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
}

//判断栈是否已经满了 
int full()
{
	return 0;
}

//判断栈是否是空的
int empty()
{
	return !head.p_next;
}

//放置新数据的函数
void push(int num)
{
	node *p_temp = (node *)malloc(sizeof(node));
	if(p_temp)
	{
		p_temp -> num = num;
		p_temp -> p_next = head.p_next;
		head.p_next = p_temp;
	}
}

//取数据的函数
int pop()
{
	int num = 1 << 31;
	if(head.p_next)
	{
		node *p_temp = head.p_next;
		num = head.p_next -> num;
		head.p_next = head.p_next -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
	return num;
}

//获得最后一个数据的函数
int last()
{
	int num = 1 << 31;
	if(head.p_next)
	{
		num = head.p_next -> num;
	}
	return num;
}

//获得有效数据个数的函数
int size()
{
	int cnt = 0;
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		if(p_node -> p_next)	
		{
			cnt++;
		}
	}
	return cnt;
}
