/*************************************************************************
    > File Name: linklist.c
    > Author: yuri
    > Mail: yuri_chen_28@163.com
    > Created Time: 2019年05月04日 星期六 10时14分34秒
	> 链表的演示
 ************************************************************************/
#include<stdio.h>
#include<stdlib.h>
#include"linklist.h"
typedef struct node
{
	int num;
	struct node *p_next;
}node;

static node head;

//初始化函数
void init()
{
	head.p_next = NULL;
}

//清理函数
void deinit()
{
	while(head.p_next)
	{
		node *p_temp = head.p_next;
		head.p_next = p_temp -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
}

//判断是否满的函数
int full()
{
	return 0;
}

//判断是否空的函数
int empty()
{
	return !(head.p_next);
}

//插入一节点
void insert_head(int num)
{
	node *p_temp = (node *)malloc(sizeof(node));
	if(p_temp)
	{
		p_temp -> num = num;
		p_temp -> p_next = head.p_next;
		head.p_next = p_temp;
	}
}

//删除一节点
void remove_head()
{
	if(head.p_next)
	{
		node *p_temp = head.p_next;
		head.p_next = p_temp -> p_next;
		free(p_temp);
		p_temp = NULL;
	}
}

//插入尾节点
void insert_tail(int num)
{
	node *p_temp = (node*)malloc(sizeof(node));
	node *p_node = NULL;
	if(p_temp)
	{
		p_temp -> num = num;
		p_temp -> p_next = NULL;
		for(p_node = &head;p_node;p_node = p_node -> p_next)
		{
			if(!(p_node -> p_next))	
			{
				p_node -> p_next = p_temp;
				break;
			}
		}

	}
}

//删除尾节点
void remove_tail()
{
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		node *p_temp = p_node -> p_next;
		if(p_temp && !(p_temp -> p_next))
		{
			free(p_temp);
			p_temp = NULL;
			p_node -> p_next = NULL;
		}
	}
}

//获得一节点内容
int get_head()
{
	int ret = 1 << 31;
	if(head.p_next)
	{
		ret = head.p_next -> num;
	}
	return ret;
}

//获得尾节点内容
int get_tail()
{
	int ret = 1 << 31;
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		node *p_temp = p_node -> p_next;
		if(p_temp && !(p_temp -> p_next))
		{
			ret = p_temp -> num;
			break;
		}
	}
	return ret;
}

//获得有效数据个数的函数
int size()
{
	int cnt = 0;
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		if(p_node -> p_next)
		{
			cnt++;
		}
	}
	return cnt;
}

//打印
void print()
{
	node *p_node = NULL;
	for(p_node = &head;p_node;p_node = p_node -> p_next)
	{
		if(p_node -> p_next)
		{
			printf("%d ", p_node -> p_next -> num);
		}
	}
	printf("\n");
}
