/*************************************************************************
    > File Name: tree.c
    > Author: yuri
    > Mail: yuri_chen_28@163.com
    > Created Time: 2019年05月26日 星期日 20时41分56秒
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "tree.h"

//初始化
void init(tree *p_tree)
{
	p_tree -> p_root = NULL;
}

//清除函数
void deinit(tree *p_tree)
{
	if(!(p_tree -> p_root))
	{
		return;
	}
	deinit(&(p_tree -> p_root -> left));
	deinit(&(p_tree -> p_root -> right));
	printf("delete node:%d\n", p_tree -> p_root -> num);
	free(p_tree -> p_root);
	p_tree -> p_root = NULL;
}

//查找函数
tree *search(tree *p_tree, int num)
{
	if(!(p_tree -> p_root))
	{
		return NULL;
	}

	tree *p_tmp = NULL;
	if(p_tree -> p_root -> num == num)
	{
		return p_tree;
	}
	p_tmp = search(&(p_tree -> p_root -> left), num);
	if(p_tmp)
	{
		return p_tmp;
	}
	return search(&(p_tree -> p_root -> right), num);
}

//在有序二叉树中查找函数
tree *search_in_order(tree *p_tree, int num)
{
	if(!(p_tree -> p_root))
	{
		return p_tree;
	}
	if(p_tree -> p_root -> num == num)
	{
		return p_tree;
	}	
	else if(p_tree -> p_root -> num > num)
	{
		return search_in_order(&(p_tree -> p_root -> left), num);
	}
	else
	{
		return search_in_order(&(p_tree -> p_root -> right), num);
	}
}

//按顺序在有序二叉树中插入新数字
void insert_in_order(tree *p_tree, int num)
{
	tree *p_position = search_in_order(p_tree, num);
	if(!(p_position -> p_root))
	{
		node *p_tmp = (node*)malloc(sizeof(node));
		if(p_tmp)
		{
			p_tmp -> num = num;
			p_tmp -> left.p_root = NULL;
			p_tmp -> right.p_root = NULL;
			p_position -> p_root = p_tmp;
		}
	}	
}

//统计二叉树中节点个数
int count(tree *p_tree)
{
	int cnt = 0;
	if(!(p_tree -> p_root))
	{
		return 0;
	}
	cnt = count(&(p_tree -> p_root -> left));
	cnt += count(&(p_tree -> p_root -> right));
	return cnt + 1;
}

//计算树的高度
int height(tree *p_tree)
{
	int lheight = 0, rheight = 0;
	if(!(p_tree -> p_root))
	{
		return 0;
	}	
	lheight = height(&(p_tree -> p_root -> left));
	rheight = height(&(p_tree -> p_root -> right));
	return (lheight > rheight ? lheight : rheight) + 1;
}